VERSION 5.00
Object = "{34290583-1728-11D2-B45B-000021692342}#1.0#0"; "Atx45.ocx"
Begin VB.Form FrmALLTextSample 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "ALLText 4.5 HT/Pro Sample - Requires Extended Features Support License and (atx45.ocx v.1.64 or newer) "
   ClientHeight    =   6900
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   11625
   Icon            =   "FrmALLTextSample.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   Picture         =   "FrmALLTextSample.frx":030A
   ScaleHeight     =   6900
   ScaleWidth      =   11625
   StartUpPosition =   1  'CenterOwner
   Begin VB.ComboBox CmbMouseWheel 
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   8.25
         Charset         =   204
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   330
      Left            =   7950
      TabIndex        =   6
      Text            =   "Select"
      Top             =   1530
      Width           =   1995
   End
   Begin VB.CommandButton BtnPrint 
      BackColor       =   &H00FFC0C0&
      Caption         =   "Print"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   10020
      MouseIcon       =   "FrmALLTextSample.frx":105A6C
      MousePointer    =   99  'Custom
      Style           =   1  'Graphical
      TabIndex        =   5
      ToolTipText     =   " Print "
      Top             =   2790
      Width           =   1485
   End
   Begin VB.CommandButton BtnLoad 
      BackColor       =   &H00FFC0C0&
      Caption         =   "Load File"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   10020
      MouseIcon       =   "FrmALLTextSample.frx":105BBE
      MousePointer    =   99  'Custom
      Style           =   1  'Graphical
      TabIndex        =   3
      ToolTipText     =   " Load File "
      Top             =   2100
      Width           =   1485
   End
   Begin VB.CommandButton BtnClear 
      BackColor       =   &H00FFC0C0&
      Caption         =   "Clear"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   10020
      MouseIcon       =   "FrmALLTextSample.frx":105D10
      MousePointer    =   99  'Custom
      Style           =   1  'Graphical
      TabIndex        =   2
      ToolTipText     =   " Clear Contents of ALLText "
      Top             =   4920
      Width           =   1485
   End
   Begin VB.CommandButton BtnExit 
      BackColor       =   &H00FFC0C0&
      Caption         =   "Exit"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   10020
      MouseIcon       =   "FrmALLTextSample.frx":105E62
      MousePointer    =   99  'Custom
      Style           =   1  'Graphical
      TabIndex        =   1
      ToolTipText     =   " Close Application "
      Top             =   5610
      Width           =   1485
   End
   Begin ATX45Lib.ATX45 ATX451 
      Height          =   4095
      Left            =   210
      TabIndex        =   4
      Top             =   1980
      Width           =   9705
      _Version        =   65536
      _ExtentX        =   17119
      _ExtentY        =   7223
      _StockProps     =   113
      BackColor       =   16777215
      BorderStyle     =   1
      FlagDesignTime  =   -1  'True
      HTMLCode        =   ""
      LcPresent       =   -1  'True
      ReleaseIt       =   -1  'True
      AtxCtlIt        =   0   'False
      Table3It        =   -1  'True
      ExtendIt        =   -1  'True
      HTMLLicExist    =   -1  'True
      _Version        =   65536
      _ExtentX        =   17119
      _ExtentY        =   7223
      _StockProps     =   113
      BackColor       =   16777215
      BorderStyle     =   1
      DirectScreenOut =   -1  'True
      BufferedKbd     =   -1  'True
      BorderStyle     =   1
      FontColor       =   0
      ObjectRefreshMethod=   0
      WriteProtect    =   0
      DocWidth        =   6000
      BackPictureX    =   0
      BackPictureY    =   0
      ScrollBarV      =   0
      ScrollBarH      =   0
      F2ON            =   -1  'True
      FormatPaste     =   -1  'True
      Overtype        =   0   'False
      BackStyle       =   1
      FileName        =   ""
      CaretWidth      =   1
      TabEnabled      =   -1  'True
      MouseHPointer   =   0
      MousePointer    =   0
      OleVerb         =   0
      DataType        =   0
      F3ON            =   -1  'True
      OleCode         =   64
      ChangeEventMask =   3
      DropFileMode    =   0
      PrinterDC       =   0   'False
      SelFType        =   4
      Palette         =   "FrmALLTextSample.frx":105FB4
      ShowPages       =   0
      ShowHidden      =   -1  'True
      DefFontName     =   "MS SANS SERIF"
      DefFontSize     =   8
      UserCursor      =   "FrmALLTextSample.frx":10600A
      UserHCursor     =   "FrmALLTextSample.frx":106026
      ShowGrid        =   3
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "MouseWheelEnabled"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   8.25
         Charset         =   204
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   195
      Left            =   7950
      TabIndex        =   8
      Top             =   1320
      Width           =   1800
   End
   Begin VB.Label Label4 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "MOUSE WHEEL SUPPORT"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   24
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800000&
      Height          =   555
      Left            =   5550
      TabIndex        =   7
      Top             =   510
      Width           =   5955
   End
   Begin VB.Label LblAboutBox 
      BackStyle       =   0  'Transparent
      Height          =   915
      Left            =   60
      MouseIcon       =   "FrmALLTextSample.frx":106042
      MousePointer    =   99  'Custom
      TabIndex        =   0
      ToolTipText     =   " About ALLText 4.5 HT/Pro "
      Top             =   300
      Width           =   3345
   End
End
Attribute VB_Name = "FrmALLTextSample"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'Variables for ALLText printable page width and height.
Dim ALLTextPageWidth  As Long, ALLTextPageHeight As Long
Sub LoadDoc()

    With ATX451
'Load a SampleDocument File in to ALLText
        .FileName = App.Path & "\SampleDocument.rtf"
        .DataType = Rich_Text_format
        .FileLoad = 1
    End With

End Sub
Sub StdPageSetUp()

    With ATX451
    'Set ALLText to show soft page breaks
    'Set ALLText DocWidth & PageHeight Properties to equal a standard page
        .PrinterDC = True
        .DocWidth = 1440 * 6
        .PageHeight = 1440 * 9
        .ShowPages = -1
    End With
    
End Sub
Sub SetMouseWheel()

    With ATX451
        Select Case CmbMouseWheel.ListIndex
        'set wheel scroll in pixels
            Case 0
                .MouseWheelEnabled = 0
            Case 1
                .MouseWheelEnabled = -1
            Case 2
                .MouseWheelEnabled = 10
            Case 3
                .MouseWheelEnabled = 20
            Case 4
                .MouseWheelEnabled = 30
            Case 5
                .MouseWheelEnabled = 40
        End Select
        .SetFocus
    End With
    
End Sub

Private Sub BtnClear_Click()

'Clear the contents of ALLText & re-set the focus
    With ATX451
        .ClearAll
        .SetFocus
    End With
    
End Sub

Private Sub BtnExit_Click()

'Exit sample application
    Unload Me
    
End Sub

Private Sub BtnLoad_Click()

'Load a rtf File in to ALLText
    Call LoadDoc
    
End Sub
Private Sub CmbMouseWheel_Change()

    Call SetMouseWheel
    
End Sub

Private Sub CmbMouseWheel_Click()

    Call SetMouseWheel

End Sub

Private Sub BtnPrint_Click()

    With ATX451
        
    'Set ALLText printable page width and height for 8.5 X 11 (Portrait)
        ALLTextPageWidth = 6 * 1440 '6 inches  = 1.25 margin on either side.
        ALLTextPageHeight = 9 * 1440 ' 9 inches = 1 inch margin on top and bottom.

    'Variables for printer non-printable area.
        Dim XInvMargin As Long, YInvMargin As Long
    'Calculate user printer non-printable area
        XInvMargin = (Printer.Width - Printer.ScaleWidth) / 2
        YInvMargin = (Printer.Height - Printer.ScaleHeight) / 2
        
    'Variables for X and Y coordinates for printing start position.
        Dim FirstPagePrintStartY As Long
        Dim RestPagesPrintStartY As Long
        Dim AllPagesPrintStartX As Long
    
    'X and Y coordinates to start printing at.
        AllPagesPrintStartX = (Printer.Width - ALLTextPageWidth) / 2 - XInvMargin
        FirstPagePrintStartY = (Printer.Height - ALLTextPageHeight) / 2 - YInvMargin
        RestPagesPrintStartY = (Printer.Height - ALLTextPageHeight) / 2 - YInvMargin
    
        
    'Shows internal printer dialog control for selecting and setting up printer.
    'For use with Extended Features Support License ONLY.
        .Modifications = ATX_ShowPrintDialog
        
    'Variable for PrintFullCycle method.
        Dim i As Integer, DefaultPrinterHdc As OLE_HANDLE
    'Initialize printer
        .PrintInit (DefaultPrinterHdc)
    'Print contents of ALLText control.
        i = .PrintFullCycle(DefaultPrinterHdc, FirstPagePrintStartY, RestPagesPrintStartY, ALLTextPageHeight, AllPagesPrintStartX, ALLTextPageWidth, 0, -1, "Printing Now..........")
    
    End With
        
End Sub

Private Sub Form_Load()

'Load a rtf File in to ALLText
    Call LoadDoc

'Setup page parameters
    Call StdPageSetUp

'Populate combo for MouseWheelEnabled value
    CmbMouseWheel.AddItem " 0 - disable mouse wheel", 0
    CmbMouseWheel.AddItem "-1 - skip by page", 1
    CmbMouseWheel.AddItem "10 - skip by 10 pixels", 2
    CmbMouseWheel.AddItem "20 - skip by 20 pixels", 3
    CmbMouseWheel.AddItem "30 - skip by 30 pixels", 4
    CmbMouseWheel.AddItem "40 - skip by 40 pixels", 5
    
End Sub

Private Sub LblAboutBox_Click()

'Display ALLText AboutBox
    ATX451.AboutBox
    
End Sub
